/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.pathfinding.AbstractWalkToProxy;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import org.jetbrains.annotations.NotNull;

public class EntityCitizenWalkToProxy
extends AbstractWalkToProxy {
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private final AbstractEntityCitizen citizen;

    public EntityCitizenWalkToProxy(AbstractEntityCitizen entity) {
        super((MobEntity)entity);
        this.citizen = entity;
    }

    @Override
    public Set<BlockPos> getWayPoints() {
        if (this.citizen.getCitizenColonyHandler().getColony() == null) {
            return Collections.emptySet();
        }
        return this.citizen.getCitizenColonyHandler().getColony().getWayPoints().keySet();
    }

    @Override
    public boolean careAboutY() {
        return true;
    }

    @Override
    public BlockPos getSpecializedProxy(BlockPos target, double distanceToPath) {
        IBuilding miner;
        AbstractBuildingGuards guardbuilding;
        IBuilding building = this.citizen.getCitizenColonyHandler().getWorkBuilding();
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && this.citizen.getCitizenJobHandler().getColonyJob() instanceof JobMiner && building instanceof BuildingMiner) {
            return this.getMinerProxy(target, distanceToPath, (BuildingMiner)building);
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && this.citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && building instanceof AbstractBuildingGuards && (guardbuilding = (AbstractBuildingGuards)building).getTask().equals("com.minecolonies.core.guard.setting.patrol_mine") && guardbuilding.getMinePos() != null && (miner = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(guardbuilding.getMinePos())) instanceof BuildingMiner) {
            return this.getMinerProxy(target, distanceToPath, (BuildingMiner)miner);
        }
        return null;
    }

    @NotNull
    private BlockPos getMinerProxy(BlockPos target, double distanceToPath, @NotNull BuildingMiner building) {
        MinerLevelManagementModule module = building.getFirstModuleOccurance(MinerLevelManagementModule.class);
        Level level = module.getCurrentLevel();
        BlockPos ladderPos = building.getLadderLocation();
        if (level != null) {
            BlockPos vector = building.getLadderLocation().func_177973_b((Vector3i)building.getCobbleLocation());
            int levelDepth = level.getDepth() + 2;
            int targetY = target.func_177956_o();
            int workerY = this.citizen.func_233580_cy_().func_177956_o();
            if (workerY <= levelDepth && targetY > levelDepth) {
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    Node currentNode = level.getNode(module.getActiveNode().getParent());
                    if (currentNode == null) {
                        module.setActiveNode(null);
                        module.setOldNode(null);
                        return this.getProxy(target, this.citizen.func_233580_cy_(), distanceToPath);
                    }
                    while (currentNode.getParent() != null) {
                        if (currentNode.getStyle() == Node.NodeType.SHAFT) {
                            Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(currentNode.getX(), 0, currentNode.getZ()));
                            BlockPos ladderHeight = new BlockPos(ladderPos.func_177958_n(), targetY + 1, ladderPos.func_177952_p());
                            return new BlockPos((Vector3i)ladderHeight.func_177967_a(facing, 7));
                        }
                        this.addToProxyList(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                this.addToProxyList(new BlockPos(ladderPos.func_177958_n() + vector.func_177958_n() * 6, level.getDepth(), ladderPos.func_177952_p() + vector.func_177952_p() * 6));
                return this.getProxy(target, this.citizen.func_233580_cy_(), distanceToPath);
            }
            if (targetY <= levelDepth && workerY > levelDepth) {
                BlockPos buildingPos = building.getPosition();
                BlockPos newProxy = this.getProxy(buildingPos, this.citizen.func_233580_cy_(), BlockPosUtil.getDistanceSquared(this.citizen.func_233580_cy_(), buildingPos));
                if (buildingPos.func_177956_o() - level.getDepth() > 25) {
                    this.addToProxyList(new BlockPos(ladderPos.func_177958_n() + vector.func_177958_n(), level.getDepth() + (buildingPos.func_177956_o() - level.getDepth()) / 2, ladderPos.func_177952_p() + vector.func_177952_p()));
                }
                this.addToProxyList(new BlockPos(ladderPos.func_177958_n() + vector.func_177958_n() * 6, level.getDepth(), ladderPos.func_177952_p() + vector.func_177952_p() * 6));
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    this.calculateNodes(level, levelDepth, building);
                }
                return newProxy;
            }
            if (targetY <= levelDepth) {
                double closestNode = Double.MAX_VALUE;
                Node lastNode = null;
                for (Map.Entry<Vec2i, Node> node : level.getNodes().entrySet()) {
                    double distanceToNode = node.getKey().distanceSq(this.citizen.func_233580_cy_().func_177958_n(), this.citizen.func_233580_cy_().func_177952_p());
                    if (!(distanceToNode < closestNode)) continue;
                    lastNode = node.getValue();
                    closestNode = distanceToNode;
                }
                if (lastNode != null && lastNode.getStyle() == Node.NodeType.SHAFT) {
                    Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(lastNode.getX(), 0, lastNode.getZ()));
                    BlockPos ladderHeight = new BlockPos(ladderPos.func_177958_n(), targetY + 1, ladderPos.func_177952_p());
                    return new BlockPos((Vector3i)ladderHeight.func_177967_a(facing, 7));
                }
                if (lastNode != null && lastNode.getParent() != null) {
                    Node currentNode = level.getNode(lastNode.getParent());
                    while (new Vec2i(currentNode.getX(), currentNode.getZ()).equals(currentNode.getParent()) && currentNode.getParent() != null) {
                        this.addToProxyList(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                if (module.getActiveNode() != null && module.getActiveNode().getParent() != null) {
                    this.calculateNodes(level, levelDepth, building);
                }
                if (!this.getProxyList().isEmpty()) {
                    return this.getProxyList().get(0);
                }
                return target;
            }
        }
        return this.getProxy(target, this.citizen.func_233580_cy_(), distanceToPath);
    }

    private void calculateNodes(Level level, int levelDepth, BuildingMiner buildingMiner) {
        ArrayList<BlockPos> nodesToTarget = new ArrayList<BlockPos>();
        Node currentNode = level.getNode(buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class).getActiveNode().getParent());
        while (currentNode != null && currentNode.getParent() != null) {
            if (currentNode.getStyle() == Node.NodeType.SHAFT) {
                BlockPos ladderPos = buildingMiner.getLadderLocation();
                Direction facing = BlockPosUtil.getXZFacing(ladderPos, new BlockPos(currentNode.getX(), 0, currentNode.getZ()));
                BlockPos ladderHeight = new BlockPos(ladderPos.func_177958_n(), levelDepth + 1, ladderPos.func_177952_p());
                nodesToTarget.add(new BlockPos((Vector3i)ladderHeight.func_177967_a(facing, 7)));
            } else {
                nodesToTarget.add(new BlockPos(currentNode.getX(), levelDepth, currentNode.getZ()));
            }
            currentNode = level.getNode(currentNode.getParent());
        }
        for (int i = nodesToTarget.size() - 1; i >= 0; --i) {
            this.addToProxyList((BlockPos)nodesToTarget.get(i));
        }
    }

    @Override
    public boolean isLivingAtSiteWithMove(MobEntity entity, int x, int y, int z, int range) {
        if (!WorkerUtil.isWorkerAtSiteWithMove((AbstractEntityCitizen)entity, x, y, z, range)) {
            EntityUtils.tryMoveLivingToXYZ(entity, x, y, z);
            return false;
        }
        return true;
    }
}

